
$TITLE  Glass Optim Case 3b: Linear or nonlin property models w/o uncert  (modified constraints)

$OFFUPPER OFFSYMXREF OFFSYMLIST

$ONTEXT
This program was last modified by Amit Goyal and Urmila Diwekar
***********************************************************************
***********************************************************************
* NOTICE: The OWL models are undergoing continuing development.       *
* They have not been verified or validated, and software control      *
* procedures have not yet been implemented.  Any use of the results   *
* of this software are the sole responsibility of the user.  The      *
* developer of this software makes no claims as to the accuracy,      *
* completeness, or usefulness of information as a result of the       *
* software's use.                                                     *
***********************************************************************
***********************************************************************



MODEL DESCRIPTION

This is the base case (OWL-Base) formulation of the waste loading
maximization problem.  It uses linear or nonlinear glass property
models and does not take into account uncertainties in the models.  It
requires the following additional files.  Different versions of each
may exist, allowing flexibility in running different types of problems
without modifying the main model code.  The required files (and
different versions) are listed below:

  input1.1inc   - contains all changeable parameters except for waste
                 composition
  wastcomp.prn - a lotus 123 print file that contains waste composition
                 data (in a specific format)
  glmdl11.inc   - contains the coefficients for the glass property models
  calcspec11.inc - contains the instructions for performing the
                 calculations, calculating additional information, and
                 printing output
  $OFFTEXT
$OFFTEXT

* Turn off equation listing in output
OPTION LIMROW = 0
OPTION LIMCOL = 0


* Define primary index variables ========================================

SETS
  Mstr  master set of all set elements
        /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  Comp(Mstr) input file waste components and parameters
             /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet, OxideMass  /
  C(Mstr)  all waste components tracked
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3,
                 ZrO2, Other, Cr2O3, F, P2O5, SO3, NobMet/
  I(Mstr)  waste components for glass property models
           /SiO2, B2O3, Na2O, Li2O, CaO, MgO, Fe2O3, Al2O3, ZrO2, Other/
  Blends   declaring the three blends  /blend1*blend3/;

$ONTEXT
The waste components in set K are treated differently than those in set
I. They are included in the glass property models as part of Other.
Their only use is for solubility constraints (expressed as upper limits
on the variables).
$OFFTEXT

* Make index J equivalent to index I (necessary for matrix computations)
ALIAS (I,J);


* Declare Parameters and Variables ======================================

PARAMETERS

  Viscosity(Blends)  PaS
  ElectCond(Blends)  'S/m'
  BorDissPCT(Blends) 'g/m2/day'
  BorDissMCC(Blends) 'g/m2/day'
  MassOxide(Blends)  total mass (kg) of oxides in waste
  CanMass            mass (kg) of glass per canister;

POSITIVE VARIABLES

  FW(Blends,Mstr)    Mass fraction of each component in the waste
  NumCans(Blends)    Number of canisters of glass required
  FG(Blends,Mstr)    Mass fraction of each component in the glass
  FF(Blends,Mstr)    Mass fraction of each component in the frit
  TMWG(Blends)       Total mass (per canister) of waste in the glass (kg)
  TMFG(Blends)       Total mass (per canister) of frit in the glass (kg)
  WasteFrac(Blends)  Fraction of mass of glass log that is waste
  Glass(Blends)      Total mass of glass formed in each blend
  Frit(Blends)       Total mass of frit added in each blend
  ;


FREE VARIABLE

 Totalfrit ;


* Set values of scalars, parameters, variable bounds, initial values  ===

$include "input11.inc"

$include "wastcompminlp.prn"

* Read PRN file with waste set declarations =============================
* and waste compositions

BINARY VARIABLE

 y(Blends, Waste)   decision variables ;

Positive variables z(Blends, Waste)   decision variables;

$include "decvarinputminlpo.inc"

* Read PRN file with blends sets declarations =============================


* Define glass property model coefficients ==============================

$include "glmdl11.inc"


* Define equations and constraints ======================================

EQUATIONS
  Totfrit
  Decvar(Waste)
  Decvars(Blends)
  FracW(Blends,C)
  Equal(Blends,Waste)
  Numcan(Blends)
  Glas(Blends)
  Fritt(Blends)
  WasteFract(Blends)   defines mass fraction of waste glass - maximized variable
  FracSumF(Blends)     sum of mass fractions in frit must = 1.0
  FracSumG(Blends)     sum of mass fractions in glass must = 1.0
  GlassComp(Blends,C)  calculate glass mass fractions for glass model components
  GlassMass(Blends)    glass = waste + frit
  Crystal1(Blends)     glass crystallinity constraint
  Crystal2(Blends)     glass crystallinity constraint
  Crystal3(Blends)     glass crystallinity constraint
  Crystal4(Blends)     glass crystallinity constraint
  Crystal5(Blends)     glass crystallinity constraint
  ViscLwr(Blends)      viscosity greater than lower limit
  ViscUpr(Blends)      viscosity less than upper limit
  ECondLwr(Blends)     e-conductivity greater than lower limit
  ECondUpr(Blends)     e-conductivity less than upper limit
  DissPCTbor(Blends)   dissolution rate for boron by PCT test less than max allowable
  DissMCCbor(Blends)   dissolution rate for boron by MCC test less than max allowable
  ;





  Decvar(Waste)   ..         SUM(Blends, y(Blends, Waste)) =E= 1;

  Decvars(Blends) ..         SUM(Waste, y(Blends,Waste)) =E= 7;

  Equal(Blends,Waste) ..     y(Blends,Waste) =E= z(Blends,Waste);

  FracW(Blends,C)    ..      FW(Blends,C)*Massoxide(Blends)   =E= SUM(Waste, y(Blends,Waste) * WasteComps(C,                                    Waste)*WasteComps('OxideMass', Waste));

  Numcan(Blends)     ..      NumCans(Blends)*TMWG(Blends) =E= MassOxide(Blends);

  Glas(Blends)       ..      Glass(Blends)   =E= NumCans(Blends)* MaxLogMass;

  Fritt(Blends)      ..      Frit(Blends)    =E= NumCans(Blends)* TMFG(Blends);

  Totfrit         ..         Totalfrit =E= SUM(Blends,Frit(Blends));

  WasteFract(Blends) ..      WasteFrac(Blends)*MaxLogMass  =E= TMWG(Blends);

  FracSumF(Blends) ..        1.0 =E= SUM(I,FF(Blends,I));

  FracSumG(Blends) ..        1.0 =E= SUM(J,FG(Blends,J));

  GlassComp(Blends,C) ..     FG(Blends,C)*MaxLogMass =E= (FF(Blends,C)*TMFG(Blends) + FW(Blends,C)*TMWG(Blends)) ;

  GlassMass(Blends) ..       TMFG(Blends) + TMWG(Blends) =E= MaxLogMass;

  Crystal1(Blends) ..        FG(Blends,'SiO2') =G= FG(Blends,'Al2O3')*Cryst1Bnd;

  Crystal2(Blends) ..        FG(Blends,'MgO')+FG(Blends,'CaO') =L= Cryst2Bnd;

  Crystal3(Blends) ..        FG(Blends,'Fe2O3')+FG(Blends,'Al2O3')+FG(Blends,'ZrO2')+FG(Blends,'Other') =L=                             Cryst3Bnd;

  Crystal4(Blends) .. FG(Blends,'Al2O3')+FG(Blends,'ZrO2') =L= Cryst4Bnd;

  Crystal5(Blends) .. FG(Blends,'MgO')+FG(Blends,'CaO')+FG(Blends,'ZrO2') =L= Cryst5Bnd  ;

  ViscLwr(Blends)  ..  SUM(I,AV(I)*FG(Blends,I)) + SUM((I,J),BV(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =G= LOG(ViscMin) ;

  ViscUpr(Blends) ..  SUM(I,AV(I)*FG(Blends,I)) + SUM((I,J),BV(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(ViscMax) ;

  ECondLwr(Blends) .. SUM(I,AE(I)*FG(Blends,I)) + SUM((I,J),BE(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =G= LOG(ECondMin) ;

  ECondUpr(Blends) ..  SUM(I,AE(I)*FG(Blends,I)) + SUM((I,J),BE(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(ECondMax) ;

  DissPCTbor(Blends).. SUM(I,ADPB(I)*FG(Blends,I)) + SUM((I,J),BDPB(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(DissMaxPCT) ;

  DissMCCbor(Blends).. SUM(I,ADMB(I)*FG(Blends,I)) + SUM((I,J),BDMB(I,J)*FG(Blends,I)*FG(Blends,J))
                                                    =L= LOG(DissMaxMCC) ;

* Declare model name  ===================================================

MODEL WASTEOPTIM /ALL/;
WASTEOPTIM.OPTFILE = 1;

option sysout=on;
option domlim = 100;




$include "calcspec11.inc"